#define MyAppName    "RustPlusDesk"
#define MyAppExe     "RustPlusDesk.exe"   ; falls anders, hier anpassen
#define MyAppVersion "3.1.0"
#define GUID "{F0BC13DE-0FE1-4EF1-B4EF-0D63E0E38B0D}" ; Einmalig eigene GUID erzeugen (Inno: Tools -> Generate GUID) und hier eintragen:
#define MyAppId      "{{E8E0C4C1-2E2F-4D2D-9BE7-3B19F0C1ABCD}}"

[Setup]
AppId={#MyAppId}
AppPublisher=Pronwan
AppPublisherURL=https://github.com/pronwan
AppName={#MyAppName}
AppVersion={#MyAppVersion}
DefaultDirName={autopf}\{#MyAppName}
DefaultGroupName={#MyAppName}
OutputBaseFilename={#MyAppName}-Setup
OutputDir=Output
Compression=lzma2
SolidCompression=yes
ArchitecturesInstallIn64BitMode=x64
Uninstallable=yes
PrivilegesRequired=admin
; Optional eigenes Setup-Icon:
SetupIconFile={#SourcePath}\1-76fc6c7e.ico
UninstallDisplayIcon={app}\{#MyAppExe}
WizardImageFile={#SourcePath}\installer.png

[Files]
; alles aus dem Publish-Ordner mitnehmen (inkl. Unterordner)
Source: "*"; DestDir: "{app}"; Flags: recursesubdirs createallsubdirs ignoreversion; Excludes: "Output\*;*.pdb;*.iss"

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExe}"
Name: "{userdesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExe}"; Tasks: desktopicon

[Tasks]
Name: "desktopicon"; Description: "Create Desktop Shortcut"; GroupDescription: "Additional Tasks:"

[Run]
Filename: "{app}\runtime\webview2\MicrosoftEdgeWebView2Bootstrapper.exe"; Parameters: "/silent /install"; Flags: runhidden; Check: FileExists(ExpandConstant('{app}\runtime\webview2\MicrosoftEdgeWebView2Bootstrapper.exe'))
Filename: "{app}\{#MyAppExe}"; Description: "{cm:LaunchProgram,{#MyAppName}}"; Flags: nowait postinstall skipifsilent